#include <math.h>
#include <stdlib.h>
#include "../common/objects.h"
#include "vector.h"
#include "../common/structs.h"
#include "../common/debug.h"

void create_rotation_matrix(double rotation[3][3], double x, double y, double z)
{
	rotation[0][0] = cos(y)*cos(z);
	rotation[0][1] = -sin(z);
	rotation[0][2] = sin(y);
	
	rotation[1][0] = sin(z);
	rotation[1][1] = cos(x)*cos(z);
	rotation[1][2] = -sin(x);

	rotation[2][0] = -sin(y);
	rotation[2][1] = sin(x);
	rotation[2][2] = cos(x)*cos(y);
}

void matrix_mul_vector(vector *out, double r[3][3], vector *v)
{
	out->x = v->x * r[0][0] + v->y * r[1][0] + v->z * r[2][0];
	out->y = v->x * r[0][1] + v->y * r[1][1] + v->z * r[2][1];
	out->z = v->x * r[0][2] + v->y * r[1][2] + v->z * r[2][2];
}